// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : game.cpp
// Date           : February 2008
//
// Description    : This file defines the Game class responsible for handling
//                  level GUI and gameplay.  Once instantiated, Update()
//                  must be called within the main game loop while the game
//                  is active.  Stop() is used to determine if the game
//                  has been exited.  Victory() is used to determine if,
//                  after the game has exited, whether or not the player
//                  collected all the tokens.  In which case, GetScore()
//                  is used to obtain the time to complete the level.
//
// ///////////////////////////////////////////////////////////////////////////
#pragma once



#include "global.h"
#include "level.h"
#include "text.h"
#include "entityPlayer.h"
#include "GameState.h"

#include <set>
#include <utility>



class EntityTokenCollector;

class Game : public GameState
{

  protected:

    // used to store collected items and opened doors
    std::map<int,std::set<std::pair<int,int> > >    m_CollectedItems;

    std::map<int,std::set<int> >       m_ReadMessages;

    std::map<int,std::set<std::pair<int,int> > >    m_PreCollectedItems;

    std::map<int,std::set<int> >       m_PreReadMessages;

    std::map<int,std::pair<int,int> >   m_StoredSubPositions;

    float                   m_AlertPos;
    bool                    m_AlertActive;

    Sound*                  m_pSoundMessage;

    int                     m_CollectedIcons;

    bool                    m_GameWon;
    float                   m_WinDelay;

    Entity*                 m_pEntityTokens;

    Dobbs::DirFlags         m_SubShotDir;

    Level                   m_Level;
    EntityPlayer*           m_pPlayer;

    int                     m_LevelNr;

    bool                    m_Paused;

    float                   m_GetReadyDelay;

    int                     m_PlayerStartX;
    int                     m_PlayerStartY;
    int                     m_PlayerStartTokens;

    bool                    m_PreItemCollected[4];
    bool                    m_ItemCollected[4];

    void                    LoadLevel();

    void                    PanOnPlayer();

    void                    ReadMessage( int LevelPos, const std::string& SoundFile );


  public:


    Game();
    ~Game();


    virtual void            Init();
    virtual void            Exit();

    virtual void            Render();
    virtual void            Update();
    virtual void            UpdateTimed( const float ElapsedTime );

    std::string             GetSignText();

    void                    OnCollision( Entity* pEntity1, Entity* pEntity2 );
    void                    OnGameEvent( Dobbs::GameEvent GEvent );

    void                    WalkThroughDoor( Entity* pDoor );
    void                    Warp( int Level, int X, int Y );

    void                    ActivateCollector( EntityTokenCollector* pCollector );

    bool                    IsTileSign( Dobbs::TileType Tile );

    void                    Restart();

    virtual void            OnAppPaused( bool Pause );

    void                    StoreSubPosition( int X, int Y );

    void                    PreCollect( int X, int Y );

};

